figure(1)
% real data
pixelSize = 3.6e-6;
offset = 78e-3;
zAxis = (1:25)*0.5e-2-offset;

% gaussian beam prop theory parameters
zStep = 5e-4;
z = -10e-2:zStep:10e-2;
w0_x = 52e-6;
z_x = -7e-3; % offset X waist in Z-axis, in mm
w0_y = 49e-6;
z_y = 2e-3; % offset Y waist in Z-axis, in mm
lambda = 800e-9;
M2x = 1.05;
M2y = 1.05;

% theory calculation
w_x = w0_x .* sqrt(1+((M2x*lambda.*(z-z_x))/(pi*w0_x^2)).^2);
w_y = w0_y .* sqrt(1+((M2y*lambda.*(z-z_y))/(pi*w0_y^2)).^2);

% now plot
plot(zAxis,wx*pixelSize,'ob',zAxis,wy*pixelSize,'or',z,w_x,'-b',z,w_y,'-r')
legend('x','y','Location','NorthEast')

title('experimental knife-edge, using CCD, for RegA')
xlabel('position through focus /m')
ylabel('w /m')
ylim([0 5e-4])